<?php
/**
 * NutriTrack WP – Page d'accueil
 */
?><!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>NutriTrack – Suivi nutrition & bien-être</title>
  <?php if (function_exists('wp_head')) wp_head(); ?>
  <link rel="stylesheet" href="<?php echo esc_url( get_stylesheet_uri() ); ?>">
</head>
<body <?php if (function_exists('body_class')) body_class(); ?>>
<div class="page-wrap">

  <!-- HEADER -->
  <header class="site-header">
    <div class="brand">
      <div class="brand-logo"></div>
      <div class="brand-text">
        <div class="brand-name">NutriTrack</div>
        <div class="brand-tagline">Nutrition • Bien-être • Sport</div>
      </div>
    </div>
    <nav class="main-nav">
      <a href="#presentation">Société</a>
      <a href="#produit">Produit</a>
      <a href="#points-forts">Points forts</a>
      <a href="#carousel">Témoignages</a>
      <a href="#galerie">Galerie</a>
      <a href="#contact">Contact</a>
    </nav>
    <button class="btn-header" onclick="document.getElementById('contact').scrollIntoView({behavior:'smooth'});">
      Demander une démo
    </button>
  </header>

  <!-- HERO / MISE EN AVANT PRODUIT -->
  <section class="hero" id="produit">
    <div>
      <div class="hero-eyebrow">Application de suivi d’habitudes nutritionnelles</div>
      <h1 class="hero-title">
        Varie ton alimentation,<br>
        <span class="hero-highlight">évite les carences</span> et garde l’énergie pour le sport.
      </h1>
      <p class="hero-subtitle">
        NutriTrack aide tes utilisateurs à suivre leurs habitudes alimentaires, leur bien‑être et leur activité
        physique en quelques minutes par jour.
      </p>
      <div class="hero-points">
        <div class="badge-chip">Suivi alimentation • hydratation • activité</div>
        <div class="badge-chip">Vue santé simple & rassurante</div>
        <div class="badge-chip">Design pensé pour la motivation long terme</div>
      </div>
      <div class="hero-cta-row">
        <button class="btn-primary" onclick="document.getElementById('contact').scrollIntoView({behavior:'smooth'});">
          Planifier un appel de découverte
        </button>
        <span class="link-ghost" onclick="document.getElementById('carousel').scrollIntoView({behavior:'smooth'});">
          Voir comment les utilisateurs progressent
        </span>
      </div>
      <p class="hero-note">
        Pas de régimes extrêmes, pas de culpabilisation : uniquement des indicateurs clairs pour ancrer des habitudes durables.
      </p>
    </div>

    <div>
      <div class="phone-card">
        <div class="phone-inner">
          <div class="phone-header">
            <div style="display:flex;align-items:center;gap:6px;">
              <span class="dot-live"></span>
              <span style="font-weight:600;">Aujourd’hui</span>
            </div>
            <span style="font-size:10px;color:#64748b;">Score équilibre</span>
          </div>
          <div class="phone-main-kpi">
            <div style="flex:1;">
              <div style="font-size:11px;font-weight:600;color:#0f172a;margin-bottom:3px;">Variété alimentaire</div>
              <div class="progress-shell">
                <div class="progress-fill"></div>
              </div>
              <div style="font-size:10px;color:#64748b;margin-top:3px;">5 groupes d’aliments sur 7 couverts</div>
            </div>
            <div style="min-width:80px;text-align:right;">
              <div style="font-size:11px;color:#64748b;">Score du jour</div>
              <div style="font-size:18px;font-weight:700;color:#0f172a;">84<span style="font-size:10px;font-weight:500;">/100</span></div>
              <div style="font-size:10px;color:#16a34a;">+12 pts vs moyenne</div>
            </div>
          </div>
          <div class="phone-grid" style="font-size:10px;">
            <div style="background:#f9fafb;border-radius:999px;padding:6px 8px;border:1px solid #e5e7eb;">
              <div style="font-size:9px;color:#64748b;">Hydratation</div>
              <div style="font-weight:600;color:#0f172a;">6/8 verres</div>
            </div>
            <div style="background:#f9fafb;border-radius:999px;padding:6px 8px;border:1px solid #e5e7eb;">
              <div style="font-size:9px;color:#64748b;">Activité</div>
              <div style="font-weight:600;color:#0f172a;">42 min</div>
            </div>
            <div style="background:#f9fafb;border-radius:999px;padding:6px 8px;border:1px solid #e5e7eb;">
              <div style="font-size:9px;color:#64748b;">Sommeil ressenti</div>
              <div style="font-weight:600;color:#0f172a;">7/10</div>
            </div>
          </div>
          <div style="margin-top:8px;font-size:10px;color:#64748b;">
            “Aujourd’hui, pense surtout à ajouter des légumes verts et un verre d’eau avant 17h.”
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- PRÉSENTATION SOCIÉTÉ -->
  <section class="section" id="presentation">
    <div class="section-title">Présentation de la société</div>
    <p class="section-subtitle">
      NutriTrack est une jeune société spécialisée dans les outils numériques de prévention santé,
      à la croisée de la nutrition, du bien‑être et du sport.
    </p>
    <div class="two-col">
      <div>
        <p style="font-size:14px;color:var(--text-muted);margin-bottom:10px;">
          Nous concevons des applications qui rendent les recommandations nutritionnelles simples à comprendre et à appliquer
          au quotidien, sans surcharge d’informations.
        </p>
        <p style="font-size:14px;color:var(--text-muted);">
          Notre équipe réunit des profils nutrition, data et produit digital pour proposer une expérience fiable,
          motivante et rassurante pour les utilisateurs finaux comme pour les professionnels.
        </p>
      </div>
      <div class="card">
        <h3>En quelques chiffres</h3>
        <ul style="list-style:none;font-size:13px;color:var(--text-muted);margin-top:6px;">
          <li>• 3 domaines clés : nutrition, bien‑être mental, activité physique</li>
          <li>• Approche co‑construite avec des diététiciens et coachs sportifs</li>
          <li>• Ambition : devenir la brique “habitudes” de référence pour les acteurs santé & sport</li>
        </ul>
      </div>
    </div>
  </section>

  <!-- POINTS FORTS / CE QUI NOUS REND UNIQUES -->
  <section class="section" id="points-forts">
    <div class="section-title">Ce qui nous rend uniques</div>
    <p class="section-subtitle">Une approche holistique pour créer la confiance et l’engagement sur la durée.</p>
    <div class="grid-3">
      <div class="card">
        <h3>Vision santé avant tout</h3>
        <p>
          L’app est pensée comme un outil de prévention et de pédagogie, pas comme un compteur de calories angoissant.
        </p>
      </div>
      <div class="card">
        <h3>Design rassurant & sportif</h3>
        <p>
          Palette bleu‑vert, micro‑animations et visualisations simples pour évoquer à la fois la fiabilité santé
          et l’énergie du sport.
        </p>
      </div>
      <div class="card">
        <h3>Adaptée à vos besoins</h3>
        <p>
          Modules configurables (éducation nutritionnelle, programmes d’activité, suivi de challenges) en fonction
          de votre public cible.
        </p>
      </div>
    </div>
  </section>

  <!-- CAROUSEL (témoignages / use cases) -->
  <section class="section" id="carousel">
    <div class="section-title">Ils utilisent NutriTrack</div>
    <p class="section-subtitle">Exemples d’usage côté utilisateurs finaux et partenaires.</p>
    <div class="carousel" data-carousel>
      <div class="carousel-track">
        <div class="carousel-item">
          <h3 style="font-size:15px;margin-bottom:6px;">Programme bien‑être en entreprise</h3>
          <p style="font-size:14px;color:var(--text-muted);">
            “Nos collaborateurs suivent désormais leurs habitudes de façon ludique. Les scores hebdomadaires ont
            permis d’animer des challenges collectifs sans tomber dans la compétition malsaine.”
          </p>
        </div>
        <div class="carousel-item">
          <h3 style="font-size:15px;margin-bottom:6px;">Salle de sport & coaching</h3>
          <p style="font-size:14px;color:var(--text-muted);">
            “En complément du suivi d’entraînement, NutriTrack donne une vision claire de la cohérence entre
            alimentation, énergie et performance de nos adhérents.”
          </p>
        </div>
        <div class="carousel-item">
          <h3 style="font-size:15px;margin-bottom:6px;">Accompagnement nutritionnel</h3>
          <p style="font-size:14px;color:var(--text-muted);">
            “Les patients arrivent en consultation avec des tendances visuelles plutôt que des tableaux,
            ce qui facilite le dialogue et la pédagogie.”
          </p>
        </div>
      </div>
      <div class="carousel-nav">
        <button type="button" style="border:none;background:none;font-size:12px;cursor:pointer;color:var(--text-muted);" data-prev>Précédent</button>
        <div class="carousel-dots">
          <div class="carousel-dot active"></div>
          <div class="carousel-dot"></div>
          <div class="carousel-dot"></div>
        </div>
        <button type="button" style="border:none;background:none;font-size:12px;cursor:pointer;color:var(--text-muted);" data-next>Suivant</button>
      </div>
    </div>
  </section>

  <!-- GALERIE D’IMAGES -->
  <section class="section" id="galerie">
    <div class="section-title">Aperçu de l’application</div>
    <p class="section-subtitle">Quelques écrans clés pour illustrer l’expérience utilisateur.</p>
    <div class="gallery-grid">
      <div class="gallery-item">
        <!-- Remplace par tes vraies captures : <img src="..." alt=""> -->
      </div>
      <div class="gallery-item"></div>
      <div class="gallery-item"></div>
      <div class="gallery-item"></div>
      <div class="gallery-item"></div>
      <div class="gallery-item"></div>
    </div>
  </section>

  <!-- CTA PRINCIPAL -->
  <section class="section">
    <div class="cta-block">
      <div>
        <h3 style="font-size:18px;margin-bottom:4px;">Discutons de votre projet</h3>
        <p>
          Vous travaillez sur une offre santé, bien‑être ou sport et souhaitez proposer un suivi d’habitudes simple
          et fiable à vos utilisateurs ?
        </p>
      </div>
      <button class="btn-primary" onclick="document.getElementById('contact').scrollIntoView({behavior:'smooth'});">
        Prendre rendez‑vous
      </button>
    </div>
  </section>

  <!-- NOTRE HISTOIRE / ÉQUIPE / VALEURS -->
  <section class="section" id="notre-histoire">
    <div class="section-title">Notre histoire & nos valeurs</div>
    <p class="section-subtitle">
      Une équipe entre nutrition, produit digital et data, alignée sur une même conviction : la prévention doit être simple.
    </p>
    <div class="two-col">
      <div>
        <h3 style="font-size:16px;margin-bottom:6px;">Notre histoire</h3>
        <p style="font-size:14px;color:var(--text-muted);">
          NutriTrack est né de la frustration de voir des proches abandonner les outils de suivi classiques,
          trop complexes et culpabilisants. Nous avons décidé de repenser entièrement l’expérience utilisateur.
        </p>
      </div>
      <div>
        <h3 style="font-size:16px;margin-bottom:6px;">Nos valeurs</h3>
        <ul style="font-size:14px;color:var(--text-muted);list-style:none;">
          <li>• Transparence sur les données et les limites de l’outil</li>
          <li>• Bienveillance dans le ton, pas de culpabilisation</li>
          <li>• Co‑construction avec professionnels & utilisateurs finaux</li>
        </ul>
      </div>
    </div>
  </section>

  <!-- CARRIÈRES (aperçu) -->
  <section class="section" id="carrieres">
    <div class="section-title">Carrières</div>
    <p class="section-subtitle">
      Nous recrutons des profils passionnés par la santé, l’expérience utilisateur et la data.
    </p>
    <div class="grid-3">
      <div class="card">
        <h3>Product Designer</h3>
        <p>Concevoir des parcours motivants et rassurants pour des utilisateurs qui ne sont pas experts santé.</p>
      </div>
      <div class="card">
        <h3>Développeur·se mobile</h3>
        <p>Participer au développement des prochaines fonctionnalités de l’app (iOS / Android).</p>
      </div>
      <div class="card">
        <h3>Data / IA santé</h3>
        <p>Travailler sur les modèles de recommandations personnalisées, en respectant les contraintes éthiques.</p>
      </div>
    </div>
  </section>

  <!-- SECTION BLOG (aperçu 4 articles) -->
  <section class="section" id="blog">
    <div class="section-title">Derniers articles du blog</div>
    <p class="section-subtitle">Éduquer sans noyer : des contenus courts et actionnables.</p>
    <div class="grid-3">
      <div class="card">
        <h3>Comprendre la variété alimentaire</h3>
        <p>Pourquoi diversifier tes sources de protéines, de fibres et de bonnes graisses est plus important que viser la perfection.</p>
      </div>
      <div class="card">
        <h3>Hydratation & niveau d’énergie</h3>
        <p>Comment 2–3 verres d’eau en plus par jour peuvent déjà améliorer la concentration et la récupération.</p>
      </div>
      <div class="card">
        <h3>Aligner nutrition & sport</h3>
        <p>Adapter légèrement tes apports les jours d’entraînement permet de mieux profiter de tes séances.</p>
      </div>
      <div class="card">
        <h3>Construire une habitude durable</h3>
        <p>Plutôt que de viser 100 %, mieux vaut viser 80 % réalistes… et tenables toute l’année.</p>
      </div>
    </div>
  </section>

  <!-- CONTACT (CTA + formulaire simple) -->
  <section class="section" id="contact">
    <div class="section-title">Contact</div>
    <p class="section-subtitle">
      Laisse-nous quelques informations et nous reviendrons vers toi rapidement.
    </p>
    <div class="two-col">
      <form action="#" method="post" class="card" style="display:flex;flex-direction:column;gap:10px;">
        <div>
          <label for="c-nom" style="font-size:13px;font-weight:500;">Nom / Société</label>
          <input id="c-nom" name="nom" type="text" required
                 style="width:100%;padding:8px 10px;border-radius:8px;border:1px solid var(--border);font-size:13px;">
        </div>
        <div>
          <label for="c-email" style="font-size:13px;font-weight:500;">Email</label>
          <input id="c-email" name="email" type="email" required
                 style="width:100%;padding:8px 10px;border-radius:8px;border:1px solid var(--border);font-size:13px;">
        </div>
        <div>
          <label for="c-objet" style="font-size:13px;font-weight:500;">Objet</label>
          <select id="c-objet" name="objet"
                  style="width:100%;padding:8px 10px;border-radius:8px;border:1px solid var(--border);font-size:13px;">
            <option value="">Sélectionner</option>
            <option value="demo">Demande de démonstration</option>
            <option value="partenariat">Partenariat</option>
            <option value="carriere">Candidature</option>
          </select>
        </div>
        <div>
          <label for="c-message" style="font-size:13px;font-weight:500;">Message</label>
          <textarea id="c-message" name="message" rows="4"
                    style="width:100%;padding:8px 10px;border-radius:8px;border:1px solid var(--border);font-size:13px;"></textarea>
        </div>
        <button type="submit" class="btn-primary">Envoyer</button>
      </form>
      <div>
        <div class="card" style="margin-bottom:14px;">
          <h3>Informations légales</h3>
          <p style="font-size:13px;color:var(--text-muted);margin-top:4px;">
            Les pages “Mentions légales”, “Carrières”, “Notre histoire” et “Blog” seront créées en tant que
            pages WordPress dédiées, accessibles depuis la navigation.
          </p>
        </div>
        <div class="card">
          <h3>Équipe & droits</h3>
          <p style="font-size:13px;color:var(--text-muted);">
            Dans WordPress, crée les membres de ton équipe (Admin, Éditeur, Auteur…) et attribue-leur les droits
            adaptés pour gérer le contenu et le blog en toute sécurité.
          </p>
        </div>
      </div>
    </div>
  </section>

  <!-- FOOTER -->
  <footer class="site-footer">
    <span>© <?php echo date('Y'); ?> NutriTrack. Application de suivi nutrition & bien‑être.</span>
    <span>
      <a href="<?php echo esc_url( home_url('/mentions-legales') ); ?>">Mentions légales</a> ·
      <a href="<?php echo esc_url( home_url('/notre-histoire') ); ?>">Notre histoire</a> ·
      <a href="<?php echo esc_url( home_url('/blog') ); ?>">Blog</a> ·
      <a href="<?php echo esc_url( home_url('/carrieres') ); ?>">Carrières</a>
    </span>
  </footer>

</div>

<?php if (function_exists('wp_footer')) wp_footer(); ?>

<script>
// Carousel très simple (JS vanilla)
document.addEventListener('DOMContentLoaded', function () {
  const carousels = document.querySelectorAll('[data-carousel]');
  carousels.forEach(c => {
    const track = c.querySelector('.carousel-track');
    const items = c.querySelectorAll('.carousel-item');
    const dots = c.querySelectorAll('.carousel-dot');
    const prev = c.querySelector('[data-prev]');
    const next = c.querySelector('[data-next]');
    let index = 0;

    function update() {
      track.style.transform = 'translateX(' + (-index * 100) + '%)';
      dots.forEach((d,i) => {
        d.classList.toggle('active', i === index);
      });
    }

    prev.addEventListener('click', () => {
      index = (index - 1 + items.length) % items.length;
      update();
    });
    next.addEventListener('click', () => {
      index = (index + 1) % items.length;
      update();
    });
  });
});
</script>
</body>
</html>
